<?php
/*********************************************
 job05.php : Jobstatus abfragen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Eigenschaften abfragen 
 4) Ergebnis anzeigen
*********************************************/
require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Client zum Abfragen von Faxjobdaten einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\Job;


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/job.php?wsdl';

// Autorisierungs-Schluessel
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Faxjob-ID, zu der Informationen abgefragt werden sollen
$jobID = "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX";


/*********************************************
3) Eigenschaften abfragen  
*********************************************/

// FaxJob instanzieren
$faxJob = new Job( $WSDL , $authkey );


/*********************************************
4) Ergebnis anzeigen
*********************************************/
//Status: 'enabled', 'halted', 'locked' oder 'canceled'
echo 'Status des Jobs '.$jobID.' : '.$faxJob->getTransportStatus($jobID);
