<?php
/*********************************************
 job06.php : Jobstatus setzen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Eigenschaften setzen
 4) Ergebnis anzeigen
*********************************************/
require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Client zum Abfragen von Faxjobdaten einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\Job;


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/job.php?wsdl';

// Autorisierungs-Schluessel
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Faxjob-ID, zu der Informationen abgefragt werden sollen
$jobID = "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX";

// Der zu setzende Status fuer den Job
$status = 'enabled';


/*********************************************
3) Eigenschaften abfragen  
*********************************************/

// FaxJob instanzieren
$faxJob = new Job( $WSDL , $authkey );

// Transportstatus setzen
//Status: 'enabled' oder 'halted'
$faxJob->setTransportStatus($jobID , $status);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Status des Jobs '.$jobID.' ist nun: '.$status;
