<?php
/*********************************************
 job08.php : Empfaenger suchen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Suche durchfuehren
 4) Ergebnis anzeigen
*********************************************/
require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Client zum Abfragen von Faxjobdaten einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\Job;


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/job.php?wsdl';

// Autorisierungs-Schluessel
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Suchparameter:  Titel (leer)
$jobTitle = NULL;

// Suchparameter:  Status (nur in abgeschlossenen Faxjobs suchen)
$status = 'finished';


/*********************************************
3) Suche durchfuehren  
*********************************************/

// FaxJob instanzieren
$faxJob = new Job( $WSDL , $authkey );

// Suchanfrage abschicken
$result = $faxJob->getMembers($jobTitle , $status);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

// Moegliche Rueckgabewerte:
// - Array von APIJob Objekten
// - NULL wenn keine Faxempfaenger gefunden wurden

if (is_array($result)) 
{
	echo '<pre>'.htmlspecialchars(print_r($result , true)).'</pre>';
} else {
	echo 'Keine Faxempfaenger gefunden';
}
