<?php
/*********************************************
 sandbox01.php : HTML als Fax ueber die sandbox senden
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/

require_once 'lib/vendor/autoload.php';

/*********************************************
 1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\SendFax;


/*********************************************
 2) Parameter des neuen Faxjobs definieren
*********************************************/

// Service-Endpunkt (hier Sandbox, nicht produktiv!)
$WSDL = 'http://phpstage80.backoffice.teamnet.de/faxapi40-sandbox/htdocs/soap/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer
$faxnumber = 'XXXXXXXXXXXXXX';

// Bezeichnung des Faxjobs
$jobtitle = 'Fax-API HTML Testfax';

// Als Faxvorlagetyp wird HTML uebergeben
$contenttype = 'text/html';

// HTML Datei laden
$content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
 3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$sendFax = new SendFax( $WSDL, $authkey );

// Faxauftrag abschicken
$jobID = $sendFax->sendFaxToFaxnumber   (	 $jobtitle
												, $contenttype
												, $content
												, $faxnumber
											);


/*********************************************
 4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$jobID.' eingeplant';
