<?php
/*********************************************
 sendfax04.php : HTML als Fax an vordefinierte Verteilerlisten senden 
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/

require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\SendFax;


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Bezeichnung des Faxjobs
$jobtitle = 'Fax-API HTML Testfax Verteilerliste';

// Als Faxvorlagetyp wird HTML uebergeben
$contenttype = 'text/html';

// HTML Datei laden
$content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';

// ID der Verteilerliste aus der Faxsuite
$distributionListID = -1;


/*********************************************
3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$sendFax = new SendFax( $WSDL, $authkey );

// Faxauftrag abschicken
$jobID = $sendFax->sendFaxToDistributionList( $jobtitle, $contenttype, $content, $distributionListID);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$jobID.' eingeplant';