<?php
/*********************************************
 exceptions01.php : HTML als Fax senden mit Exception Handling
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen 
 4) Faxauftrag einplanen & Ergebnis differenzieren
*********************************************/
require_once 'lib/vendor/autoload.php';

/*********************************************
 1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/

use Teamnet\FaxApi\Soap\Client\SendFax;
use Teamnet\FaxApi\Soap\Types\AuthenticationException;
use Teamnet\FaxApi\Soap\Types\LimitExceededException;
use Teamnet\FaxApi\Soap\Types\MaintenanceException;
use Teamnet\FaxApi\Soap\Types\ParameterException;
use Teamnet\FaxApi\Soap\Types\ServiceException;


/*********************************************
 2) Parameter des neuen Faxjobs definieren
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer
$faxnumber = 'XXXXXXXXXXXXXX';

// Bezeichnung des Faxjobs
$jobtitle = 'Fax-API HTML Testfax';

// Als Faxvorlagetyp wird HTML uebergeben
$contenttype = 'text/html';

// HTML Datei laden
$content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
 3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$sendFax = new SendFax( $WSDL, $authkey );


/*********************************************
 4) Faxauftrag einplanen & Ergebnis differenzieren
*********************************************/

try {
	// Faxauftrag abschicken
	$jobID = $sendFax->sendFaxToFaxnumber   (	 $jobtitle
													, $contenttype
													, $content
													, $faxnumber
												);

	// Meldung bei erfolgreicher Auftragseinplanung	
	echo 'Fax wird unter der Job-ID: '.$jobID.' eingeplant';
} 

// Je nach Fehlerursache werden unterschiedliche Exceptions zurueckgeliefert:
catch (ParameterException $e) {
	// Der Faxjob wurde mit mindestens einem ungueltigen Parameter an die API uebermittelt
	echo 'Parameter '.$e->parameter.': '.$e->getMessage();
} catch (AuthenticationException $e) {
	// Der Autorisierungs-Schluessel ist ungueltig
	echo $e->getMessage();
} catch (ServiceException $e) {
	// Service steht derzeit aufgrund technischer Stoerungen nicht zur Verfuegung
	echo 'Der API-Endpunkt meldet einen internen Fehler: '.$e->getMessage();
} catch (MaintenanceException $e) {
	// Service steht derzeit aufgrund eines Wartungsfensters nicht zur Verfuegung
	echo 'Wartungsarbeiten am API-Endpunkt: '.$e->getMessage();
} catch (LimitExceededException $e) {
	// Die Fax-API blockt zu hohe Versandfrequenzen und -Volumina
	echo $e->getMessage();
} catch (SoapFault $e) {
	// Der SOAP-Service meldet eine ungueltige Anfrage
	echo 'SoapFault: '.$e->getMessage();
}
