<?php
/*********************************************
 sendfax05.php : Variation von Faxversandoptionen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/

require_once 'lib/vendor/autoload.php';

/*********************************************
1) SOAP-Clients einbinden
*********************************************/

// SOAP-Client zum Versenden von Faxen einbinden
use Teamnet\FaxApi\Soap\Client\SendFax;

// SOAP-Client fuer Versandoptionen einbinden
use Teamnet\FaxApi\Soap\Types\JobOptions;


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$WSDL = 'https://service.fax-api.de/4.0/soap/sendfax.php?wsdl';

// Autorisierungs-Schluessel
$authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer mit Landesvorwahl
$faxnumber = 'XXXXXXXXXXXXXX';

// Bezeichnung des Faxjobs
$jobtitle = 'Fax-API HTML JobOptions';

// Als Faxvorlagetyp wird HTML uebergeben
$contenttype = 'text/html';

// HTML Datei laden
$content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
3) Fax einplanen
*********************************************/

// JobOptionen instanzieren
$jobOptions = new JobOptions();
// Kostenstelle
$jobOptions->costcenter = 'Kostenstelle';
// Kopfzeile im Faxdokument anzeigen
$jobOptions->faxheader = true;
// Absender-Kennung in der Kopfzeile
$jobOptions->faxheaderFrom = 'sendfax05.php';
// Station-ID
$jobOptions->stationid = 'Teamnet';
// Versandzeitpunkt
$jobOptions->timetosend = '2012-03-03T09:10:00+01:00';

// Sendfax instanzieren
$sendFax = new SendFax( $WSDL, $authkey );

// Faxauftrag abschicken
$jobID = $sendFax->sendFaxToFaxnumber	(	$jobtitle
												, $contenttype
												, $content
												, $faxnumber
												, $jobOptions
											);

											
/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$jobID.' eingeplant';
