<?php
/*
 * The script retrieves the recipients of one existing job
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Job-Details/operation/getJobRecipients
 */

$restUrl			= "https://service.fax-api.de/4.0/rest/";
$restResource		= "jobs/";
$restResourceMethod	= "/recipients";

/*
 * STEP A:
 * Set needed script variables.
 */
$token	= 'xxx'; //type here your api token
$jobID	= 'xxx'; //type here the id of the job you want to query

// array contains all available filter
$queryParameterList = [
	"objectLimit" 						=> null,
	"objectOffset" 						=> null,
	"filterFaxNumber" 					=> null,
	"filterFaxNumberNorm"				=> null,
	"filterRecipientReference"			=> null,
	"filterInternationalDialingCode"	=> null,
	"filterResultCode"					=> null,
	"filterResultText"					=> null,
	"sortField"							=> null, // "faxNumber" "faxNumberNorm" "internationalDialingCode" "recipientReference" "farZone" "senderTime"
	"sortOrder"							=> null, // "asc" "desc"
];

/*
 * STEP B:
 * Format query parameter into a string
 */
if (!empty($queryParameterList)) {
	$urlAppendix = '?';
	foreach ($queryParameterList as $queryParameterKey => $queryParameterValue) {
		if( is_null($queryParameterValue) ) {
			continue;
		}
		$urlAppendix .= $queryParameterKey.'='.$queryParameterValue.'&';
	}
	$urlAppendix = substr($urlAppendix, 0, -1);
}


/*
 * STEP C
 * Define URL
 */
$url = $restUrl.$restResource.$jobID.$restResourceMethod.$urlAppendix;

/* 
 * STEP D:
 * Create and set curl
 */
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_HTTPHEADER, [
	'Content-Type: application/json',
	'X-Auth-Token: '.$token
] );

/* 
 * STEP E:
 * Execute call 
 */
$result = curl_exec($curl);
if(!$result){die("Connection Failure");}
curl_close($curl);

/* 
 * STEP F: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;