<?php
/*
 * This script creates a new job with minimal configuration
 * Please use the script "postJobDetail.php" if you want to use more options during the creation process
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Jobs/operation/postJob
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "jobs";

/*
 * STEP A:
 * Set needed script variables
 */
$token			= 'xxx'; //type here your api token
$content		= base64_encode(file_get_contents('.././test.html')); // this file need to be at the same path where you start this script
$contentType	= 'text/html'; // supported types are: "application/pdf" "image/tiff" "image/gif" "image/png" "text/html" "text/plain"
$recipient		= 'xxx'; // type here the recipient fax number

/* 
 * STEP B:
 * Set the minimal requestBody and encode it
 */
$requestBody = [
	"templates" => [
		[
			"contentType"=> $contentType,
			"content"=> $content
		]
	],
	"recipients" => [
		[
			'faxNumber' => $recipient
		]
	]
];
$json = json_encode($requestBody);


/*
 * STEP C:
 * Define URL
 */
$url = $restUrl.$restResource;

/* 
 * STEP D:
 * Create and set curl  
 */
$curl = curl_init();
$url = $restUrl.$restResource;
curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_HTTPHEADER, [
	'Content-Type: application/json',
	'X-Auth-Token: '.$token
] );
curl_setopt($curl, CURLOPT_POST, 1);
curl_setopt($curl, CURLOPT_POSTFIELDS, $json);

/* 
 * STEP E:
 * Execute call 
 */
$result = curl_exec($curl);
if(!$result){die("Connection Failure");}
curl_close($curl);

/* 
 * STEP F: 
 * Beautify result for readable output in console
 */
$jsonResult = json_decode($result,true);
$jsonBeauty = json_encode($jsonResult, JSON_PRETTY_PRINT );
echo $jsonBeauty;