<?php
/*
 * This script creates a new job
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Jobs/operation/postJob
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "jobs";
$restMethode	= 'POST';

/*
 * STEP A:
 * Set needed script variables
 */
$token			= 'xxx'; //type here your api token
$content		= base64_encode(file_get_contents('.././testHtmlTemplate.html')); // this file need to be at the same path where you start this script
$contentType	= 'text/html'; // supported types are: "application/pdf" "image/tiff" "image/gif" "image/png" "text/html" "text/plain"
$recipient		= 'xxx'; // type here the recipient fax number

/* 
 * STEP B:
 * Set the minimal requestBody and encode it
 */
$timeToSend = new DateTime();
$timeToSend->modify("+0 day, +0 hour, +0 minute"); //set to a time according your needs

$timeToSendUntil = clone $timeToSend;
$timeToSendUntil->modify("+0 day, +0 hour, +15 minute"); //set to a time according your needs

$timeToSend = $timeToSend->format(DateTime::ATOM);
$timeToSendUntil = $timeToSendUntil->format(DateTime::ATOM);

$requestBody = [
	"options" => [
		"title" 			=> "Fax Job ABC 123",
		"timeToSend"		=> $timeToSend, // only allowed to be 2 hours in the past
		"timeToSendUntil"	=> $timeToSendUntil, // only allowed to be at least 5 minutes after TimeToSend
		"faxHeader"			=> true,
		"faxHeaderFrom"		=> "Max Mustermann",
		"stationID"			=> "test12345",
		"clip"				=> null,
		"defaultInternationalDialingCode" => "0049",
		"costCenter"		=> "Kösten",
		"saveDocuments"		=> false
	],
	"templates" => [
		[
			"contentType"	=> $contentType,
			"content"		=> $content
		]
	],
	"recipients" => [
		[
			'faxNumber' => $recipient
		]
	]
];
$json = json_encode($requestBody);

/*
 * STEP C:
 * Define URL
 */
$url = $restUrl.$restResource;

/* 
 * STEP D:
 * Define the http options  
 */
$options = [
	'http' => [
		'header' => [
			'Content-type: application/json',
			'X-Auth-Token: '.$token
		],
		'method' => $restMethode,
		'ignore_errors' => true,
		'content' => $json
	]
];
$context  = stream_context_create($options);

/* 
 * STEP E:
 * Execute call 
 */
$result = file_get_contents($url, false, $context);

/* 
 * STEP F: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;