<?php
/*
 * The script retrieves the preview of one existing job
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Job-Details/operation/getJobPreviews
 */

$restUrl			= "https://service.fax-api.de/4.0/rest/";
$restResource		= "jobs/";
$restResourceMethod	= "/preview";
$restMethode		= 'GET';

/*
 * STEP A:
 * Set needed script variables.
 */
$token	= 'xxx'; //type here your api token
$jobID	= 'xxx'; //type here the id of the job you want to query

/*
 * STEP B:
 * Define URL
 */
$url = $restUrl.$restResource.$jobID.$restResourceMethod;

/* 
 * STEP C:
 * Define the http options  
 */
$options = [
	'http' => [
		'header' => [
			'Content-type: application/json',
			'X-Auth-Token: '.$token
		],
		'method' => $restMethode,
		'ignore_errors' => true
	]
];
$context  = stream_context_create($options);

/* 
 * STEP D:
 * Execute call 
 */
$result = file_get_contents($url, false, $context);

/* 
 * STEP E: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;