<?php
/*
 * The script retrieves recipients.
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Recipients
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "recipients";
$restMethode	= 'GET';

/*
 * STEP A:
 * Set needed script variables.
 */
$token	= 'xxx'; //type here your api token

// array contains all available filter
$queryParameterList = [
	"objectLimit" 						=> null,
	"objectOffset" 						=> null,
	"filterFaxNumber" 					=> null,
	"filterFaxNumberNorm"				=> null,
	"filterRecipientReference"			=> null,
	"filterInternationalDialingCode"	=> null,
	"filterResultCode"					=> null,
	"filterResultText"					=> null,
	"sortField"							=> null, // "faxNumber" "faxNumberNorm" "internationalDialingCode" "recipientReference" "farZone" "senderTime"
	"sortOrder"							=> null, // "asc" "desc"
];

/*
 * STEP B:
 * Format query parameter into a string
 */
if (!empty($queryParameterList)) {
	$urlAppendix = '?';
	foreach ($queryParameterList as $queryParameterKey => $queryParameterValue) {
		if( is_null($queryParameterValue) ) {
			continue;
		}
		$urlAppendix .= $queryParameterKey.'='.$queryParameterValue.'&';
	}
	$urlAppendix = substr($urlAppendix, 0, -1);
}


/*
 * STEP C:
 * Define URL
 */
$url = $restUrl.$restResource.$urlAppendix;

/* 
 * STEP D:
 * Define the http options  
 */
$options = [
	'http' => [
		'header' => [
			'Content-type: application/json',
			'X-Auth-Token: '.$token
		],
		'method' => $restMethode,
		'ignore_errors' => true
	]
];
$context  = stream_context_create($options);

/* 
 * STEP E:
 * Execute call 
 */
$result = file_get_contents($url, false, $context);

/* 
 * STEP F: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;