<?php
/*
 * This script changes the state of an existing job
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/Job-Details/operation/putJob
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "jobs/";
$restMethode	= 'PUT';

/*
 * STEP A:
 * Set needed script variables
 */
$token	= 'xxx'; //type here your api token
$jobID	= 'xxx'; //type here the id of the job you want to query

/* 
 * STEP B:
 * Set the minimal requestBody and encode it
 */
$requestBody = [
	"action" => null //"hold" "cancel" "resume"
];
$json = json_encode($requestBody);


/*
 * STEP C:
 * Define URL
 */
$url = $restUrl.$restResource.$jobID;

/* 
 * STEP D:
 * Define the http options  
 */
$options = [
	'http' => [
		'header' => [
			'Content-type: application/json',
			'X-Auth-Token: '.$token
		],
		'method' => $restMethode,
		'ignore_errors' => true,
		'content' => $json
	]
];
$context  = stream_context_create($options);

/* 
 * STEP E:
 * Execute call 
 */
$result = file_get_contents($url, false, $context);

/* 
 * STEP F: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;