<?php
/*
 * The script retrieves the current state of the service
 * For more information please see documentation https://service.fax-api.de/4.0/rest/#tag/System/operation/getHealth
 */

$restUrl		= "https://service.fax-api.de/4.0/rest/";
$restResource	= "health";
$restMethode	= 'GET';

/*
 * STEP A
 * Define URL
 */
$url = $restUrl.$restResource;

/* 
 * STEP B:
 * Define the http options  
 */
$options = [
	'http' => [
		'header' => [
			'Content-type: application/json'
		],
		'method' => $restMethode,
		'ignore_errors' => true
	]
];
$context  = stream_context_create($options);

/* 
 * STEP C:
 * Execute call 
 */
$result = file_get_contents($url, false, $context);

/* 
 * STEP D: 
 * Beautify result for readable output in console
 */
$json = json_decode($result,true);
$jsonBeauty = json_encode($json, JSON_PRETTY_PRINT );
echo $jsonBeauty;