<?php
/*********************************************
 job01.php : Jobstatus abfragen 
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Eigenschaften abfragen
 4) Ergebnis anzeigen
*********************************************/

/*********************************************
1) SOAP-Client zum Abfragen von Faxjobdaten einbinden
*********************************************/

require_once 'Teamnet/Fax/Soap/Client/Job.php';


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/job.php?wsdl';

// Autorisierungs-Schluessel
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Faxjob-ID, zu der Informationen abgefragt werden sollen
$i_JobID = 1;


/*********************************************
3) Eigenschaften abfragen  
*********************************************/

// FaxJob instanzieren
$o_FaxJob = new Teamnet_Fax_Soap_Client_Job( $s_WSDL , $s_Authkey );

// Anfrage ausfuehren
$o_Result = $o_FaxJob->getJob( $i_JobID );


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Informationen zum Job '.$i_JobID.":\n";
echo '<pre>'.htmlspecialchars(print_r($o_Result, true)).'</pre>';