<?php
/*********************************************
 exceptions01.php : HTML als Fax senden mit Exception Handling
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen 
 4) Faxauftrag einplanen & Ergebnis differenzieren
*********************************************/

/*********************************************
 1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/

require_once 'Teamnet/Fax/Soap/Client/SendFax.php';


/*********************************************
 2) Parameter des neuen Faxjobs definieren
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer
$s_Faxnumber = '05251682540014989';

// Bezeichnung des Faxjobs
$s_Jobtitle = 'Fax-API HTML Testfax';

// Als Faxvorlagetyp wird HTML uebergeben
$s_Contenttype = 'text/html';

// HTML Datei laden
$s_Content = '<html><head>Fax-API Testfax</head><body><h1>Fax-API Testfax</h1><br><p>Fax-API ist Service von Faxverteiler.com - Webservice der Teamnet GmbH</p></body></html>';


/*********************************************
 3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$o_SendFax = new Teamnet_Fax_Soap_Client_SendFax( $s_WSDL, $s_Authkey );


/*********************************************
 4) Faxauftrag einplanen & Ergebnis differenzieren
*********************************************/

try {
	// Faxauftrag abschicken
	$i_JobID = $o_SendFax->sendFaxToFaxnumber   (	 $s_Jobtitle
													, $s_Contenttype
													, $s_Content
													, $s_Faxnumber
												);

	// Meldung bei erfolgreicher Auftragseinplanung	
	echo 'Fax wird unter der Job-ID: '.$i_JobID.' eingeplant';
} 

// Je nach Fehlerursache werden unterschiedliche Exceptions zurueckgeliefert:
catch (Teamnet_Fax_Soap_Type_ParameterException $e) {
	// Der Faxjob wurde mit mindestens einem ungueltigen Parameter an die API uebermittelt
	echo 'Parameter '.$e->parameter.': '.$e->getMessage();
} catch (Teamnet_Fax_Soap_Type_AuthentificationException $e) {
	// Der Autorisierungs-Schluessel ist ungueltig
	echo $e->getMessage();
} catch (Teamnet_Fax_Soap_Type_ServiceException $e) {
	// Service steht derzeit aufgrund technischer Stoerungen nicht zur Verfuegung
	echo 'Der API-Endpunkt meldet einen internen Fehler: '.$e->getMessage();
} catch (Teamnet_Fax_Soap_Type_MaintenanceException $e) {
	// Service steht derzeit aufgrund eines Wartungsfensters nicht zur Verfuegung
	echo 'Wartungsarbeiten am API-Endpunkt: '.$e->getMessage();
} catch (Teamnet_Fax_Soap_Type_LimitExceededException $e) {
	// Die Fax-API blockt zu hohe Versandfrequenzen und -Volumina
	echo $e->getMessage();
} catch (SoapFault $e) {
	// Der SOAP-Service meldet eine ungueltige Anfrage
	echo 'SoapFault: '.$e->getMessage();
}
