<?php
/*********************************************
 sendfax02.php : PDF als Fax an einen Empfaenger senden 
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Fax einplanen
 4) Ergebnis anzeigen
*********************************************/

/*********************************************
1) SOAP-Client zum Versenden von Faxen einbinden
*********************************************/
require_once 'Teamnet/Fax/Soap/Client/SendFax.php';


/*********************************************
2) Parameter des neuen Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/sendfax.php?wsdl';

// Autorisierungs-Schluessel des sendenden Fax-API Kontos
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Zielfaxnummer
$s_Faxnumber = '05251682540014989';

// Bezeichnung des Faxjobs
$s_Jobtitle = 'Fax-API PDF Testfax';

// Als Faxvorlagetyp wird ein PDF uebergeben
$s_Contenttype = 'application/pdf';

// PDF Datei laden
$s_Content = file_get_contents ('resources/example.pdf');


/*********************************************
3) Fax einplanen
*********************************************/

// Sendfax instanzieren
$o_SendFax = new Teamnet_Fax_Soap_Client_SendFax( $s_WSDL, $s_Authkey );

// Faxauftrag abschicken
$i_JobID = $o_SendFax->sendFaxToFaxnumber	(	$s_Jobtitle
												, $s_Contenttype
												, $s_Content
												, $s_Faxnumber
											);

/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Fax wird unter der Job-ID: '.$i_JobID.' eingeplant';

