<?php
/*********************************************
 job06.php : Jobstatus setzen
 1) SOAP-Client einbinden
 2) Parameter definieren
 3) Eigenschaften setzen
 4) Ergebnis anzeigen
*********************************************/


/*********************************************
1) SOAP-Client zum Abfragen von Faxjobdaten einbinden
*********************************************/

require_once 'Teamnet/Fax/Soap/Client/Job.php';


/*********************************************
2) Parameter des Faxjobs definieren 
*********************************************/

// Service-Endpunkt (produktiv)
$s_WSDL = 'https://soap.fax-api.de/2.0/job.php?wsdl';

// Autorisierungs-Schluessel
$s_Authkey = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// Die Faxjob-ID, zu der Informationen abgefragt werden sollen
$i_JobID = 1;

// Der zu setzende Status fuer den Job
$s_Status = 'enabled';


/*********************************************
3) Eigenschaften abfragen  
*********************************************/

// FaxJob instanzieren
$o_FaxJob = new Teamnet_Fax_Soap_Client_Job( $s_WSDL , $s_Authkey );

// Transportstatus setzen
$o_FaxJob->setTransportStatus($i_JobID , $s_Status);


/*********************************************
4) Ergebnis anzeigen
*********************************************/

echo 'Status des Jobs '.$i_JobID.' ist nun: '.$s_Status;
